
library(RKernel)
library(magrittr)
library(memisc)
load("CHESwork.RData")


CHESwork %<>% within({
  ChristCons <- recode(partfam,
    "Confessional" <- 10,
    "Christian-Democratic" <- 4,
    "Conservative" <- 2,
    "Radical Right" <- 1,
    "Other" <- c(3,5:9,11),
  )
  YearF <- as.factor(CHESyear)
  Western.Europe <- country %in% c(1,2,3,5,6,7,8,10,11,12,13,14,16,38)
})


names(CHESwork)


with(CHESwork,
    foreach(Dimen=c(galtan,religious_principles,immigration),
            print(range(CHESyear[is.finite(Dimen)],na.rm=TRUE))))
with(CHESwork,
    foreach(Dimen=c(galtan,religious_principles,immigration),
            print(sum(is.finite(Dimen)))))


library(ggplot2)
theme_set(theme_bw())


options(jupyter.plot.width=9)


annot <- paste("r = ",round(with(CHESwork,Cor(galtan,lrecon)),2))
ggplot(subset(CHESwork,Western.Europe),aes(x=galtan,y=lrecon)) +  
       stat_density_2d(aes(alpha = ..level..,fill=ChristCons), geom = "polygon")+ 
       geom_point(aes(col=ChristCons),alpha=.7) + guides(alpha="none") +
       annotate("text",x=0,y=10,label=annot,vjust=1,hjust=0,size=5) +
       labs(fill=NULL,col=NULL,x="GAL/TAN",y="Economic left/right")
ggsave("scatter-galtan-econlr.pdf")


options(jupyter.plot.width=9)
annot <- paste("r = ",round(with(CHESwork,Cor(religious_principles,lrecon)),2))
ggplot(subset(CHESwork,Western.Europe),aes(x=religious_principles,y=lrecon)) +  
       stat_density_2d(aes(alpha = ..level..,fill=ChristCons), geom = "polygon")+ 
       geom_point(aes(col=ChristCons),alpha=.7) + guides(alpha="none") +
       annotate("text",x=0,y=10,label=annot,vjust=1,hjust=0,size=5) +
       labs(fill=NULL,col=NULL,x="Religious principles",y="Economic left/right")
ggsave("scatter-relprin-econlr.pdf")


options(jupyter.plot.width=9)
annot <- paste("r = ",round(with(CHESwork,Cor(religious_principles,galtan)),2))
ggplot(subset(CHESwork,Western.Europe),aes(x=religious_principles,y=galtan)) +  
       stat_density_2d(aes(alpha = ..level..,fill=ChristCons), geom = "polygon")+ 
       geom_point(aes(col=ChristCons),alpha=.7) + guides(alpha="none") +
       annotate("text",x=0,y=10,label=annot,vjust=1,hjust=0,size=5) +
       labs(fill=NULL,col=NULL,x="Religious principles",y="GAL/TAN")
ggsave("scatter-relprin-galtan.pdf")


options(jupyter.plot.width=9)
annot <- paste("r = ",round(with(CHESwork,Cor(immigration,galtan)),2))
ggplot(subset(CHESwork,Western.Europe),aes(x=immigration,y=galtan)) +  
       stat_density_2d(aes(alpha = ..level..,fill=ChristCons), geom = "polygon")+ 
       geom_point(aes(col=ChristCons),alpha=.7) + guides(alpha="none") +
       annotate("text",x=0,y=10,label=annot,vjust=1,hjust=0,size=5) +
       labs(fill=NULL,col=NULL,x="Immigration",y="GAL/TAN")
ggsave("scatter-immigration-galtan.pdf")


options(jupyter.plot.width=9)
annot <- paste("r = ",round(with(CHESwork,Cor(nationalism,galtan)),2))
ggplot(subset(CHESwork,Western.Europe),aes(x=nationalism,y=galtan)) +  
       stat_density_2d(aes(alpha = ..level..,fill=ChristCons), geom = "polygon")+ 
       geom_point(aes(col=ChristCons),alpha=.7) + guides(alpha="none") +
       annotate("text",x=0,y=10,label=annot,vjust=1,hjust=0,size=5) +
       labs(fill=NULL,col=NULL,x="Nationalism",y="GAL/TAN")
ggsave("scatter-nationalism-galtan.pdf")


options(jupyter.plot.width=9)
annot <- paste("r = ",round(with(CHESwork,Cor(civlib_laworder,galtan)),2))
ggplot(subset(CHESwork,Western.Europe),aes(x=civlib_laworder,y=galtan)) +  
       stat_density_2d(aes(alpha = ..level..,fill=ChristCons), geom = "polygon")+ 
       geom_point(aes(col=ChristCons),alpha=.7) + guides(alpha="none") +
       annotate("text",x=0,y=10,label=annot,vjust=1,hjust=0,size=5) +
       labs(fill=NULL,col=NULL,x="Civil liberties",y="GAL/TAN")
ggsave("scatter-civlib-galtan.pdf")


options(jupyter.plot.width=9)
annot <- paste("r = ",round(with(CHESwork,Cor(religious_principles,sociallifestyle)),2))
ggplot(subset(CHESwork,Western.Europe),aes(x=religious_principles,y=sociallifestyle)) +  
       stat_density_2d(aes(alpha = ..level..,fill=ChristCons), geom = "polygon")+ 
       geom_point(aes(col=ChristCons),alpha=.7) + guides(alpha="none") +
       annotate("text",x=0,y=10,label=annot,vjust=1,hjust=0,size=5) +
       labs(fill=NULL,col=NULL,x="Religious principles",y="Social lifestyle")
ggsave("scatter-relprin-soclife.pdf")


options(jupyter.plot.width=9)
annot <- paste("r = ",round(with(CHESwork,Cor(religious_principles,immigration)),2))
ggplot(subset(CHESwork,Western.Europe),aes(x=religious_principles,y=immigration)) +  
       stat_density_2d(aes(alpha = ..level..,fill=ChristCons), geom = "polygon")+ 
       geom_point(aes(col=ChristCons),alpha=.7) + guides(alpha="none") +
       annotate("text",x=0,y=10,label=annot,vjust=1,hjust=0,size=5) +
       labs(fill=NULL,col=NULL,x="Religious principles",y="Immigration")
ggsave("scatter-relprin-immigration.pdf")


options(jupyter.plot.width=9)
annot <- paste("r = ",round(with(CHESwork,Cor(religious_principles,civlib_laworder)),2))
ggplot(subset(CHESwork,Western.Europe),aes(x=religious_principles,y=civlib_laworder)) +  
       stat_density_2d(aes(alpha = ..level..,fill=ChristCons), geom = "polygon")+ 
       geom_point(aes(col=ChristCons),alpha=.7) + guides(alpha="none") +
       annotate("text",x=0,y=10,label=annot,vjust=1,hjust=0,size=5) +
       labs(fill=NULL,col=NULL,x="Religious principles",y="Liberties/Law & Order")
ggsave("scatter-relprin-liborder.pdf")


options(jupyter.plot.width=9)
annot <- paste("r = ",round(with(CHESwork,Cor(immigration,civlib_laworder)),2))
ggplot(subset(CHESwork,Western.Europe),aes(x=immigration,y=civlib_laworder)) +  
       stat_density_2d(aes(alpha = ..level..,fill=ChristCons), geom = "polygon",h=c(2.5,2.5))+ 
       geom_point(aes(col=ChristCons),alpha=.7) + guides(alpha="none") +
       annotate("text",x=0,y=10,label=annot,vjust=1,hjust=0,size=5) +
       labs(fill=NULL,col=NULL,x="Immigration",y="Liberties/Law & Order")
ggsave("scatter-immigration-liborder.pdf")


options(jupyter.plot.width=9)
annot <- paste("r = ",round(with(CHESwork,Cor(immigration,nationalism)),2))
ggplot(subset(CHESwork,Western.Europe),aes(x=immigration,y=nationalism)) +  
       stat_density_2d(aes(alpha = ..level..,fill=ChristCons), geom = "polygon",h=c(3,3))+ 
       geom_point(aes(col=ChristCons),alpha=.7) + guides(alpha="none") +
       annotate("text",x=0,y=10,label=annot,vjust=1,hjust=0,size=5) +
       labs(fill=NULL,col=NULL,x="Immigration",y="Nationalism")
ggsave("scatter-immigration-nationalism.pdf")







